/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.controllo;

import java.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import it.unibas.pdd.modello.*;
import it.unibas.pdd.persistenza.*;

public class ControlloSemplice {
    
    private Configurazione configurazione;
    
    public void init(String nomeFileConfigurazione) {
        try {
            this.configurazione = DAOConfigurazione.getInstance().carica(nomeFileConfigurazione);
        } catch (DAOException daoe) {
            System.err.println(daoe);
            System.exit(0);            
        } catch (ConfigurazioneException cfe) {
            System.err.println(cfe);
            System.exit(0);            
        }
        CollezioneQuesiti archivio = configurazione.getArchivio();
        System.out.println(archivio.toString());
        generaQuestionari();
    }
    
    public void generaQuestionari() {
        CollezioneProve collezioneProve = new CollezioneProve(configurazione);
        System.out.println(collezioneProve);
        String percorso = configurazione.getCartellaDestinazione();
        try {
            DAOXML.getInstance().stampaQuestionariSuFile(collezioneProve, percorso);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
    }
    
    public static void main(String args[]) {
        if (args.length != 1) {
            System.out.println("Uso: java it.unibas.pdd.controllo.ControlloSemplice <nomeFileConfigurazione>");
        } else {
            ControlloSemplice controllo = new ControlloSemplice();
            String nomeFile = args[0];
            controllo.init(nomeFile);
        }
    } 

}
