/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.List;
import java.util.ArrayList;

public class CollezioneProve {
    
    private String id;
    private List listaGruppi = new ArrayList();
    
    public CollezioneProve(Configurazione configurazione) {
        String id = configurazione.getArchivio().getId();        
        this.id = id;
        int numeroGruppi = configurazione.getNumeroGruppi();
        for (int i = 0; i < numeroGruppi; i++) {
            GruppoQuestionari gruppoQuestionari = new GruppoQuestionari(configurazione, id+"-T-"+i);
            listaGruppi.add(gruppoQuestionari);
        }
    }
        
    public String getId() {
        return id;
    }
        
    public int getNumeroGruppi() {
        return listaGruppi.size();
    }
    
    public GruppoQuestionari getGruppoQuestionari(int i) {
        if (i < listaGruppi.size()) {
            return (GruppoQuestionari)listaGruppi.get(i);
        } else {
            return null;
        }
    }
        
    public String toString() {
        String risultato = "";
        for (int i = 0; i < listaGruppi.size(); i++) {
            GruppoQuestionari gruppoQuestionari = (GruppoQuestionari)listaGruppi.get(i);
            CollezioneQuesiti questionario = gruppoQuestionari.getQuestionario(0);
            risultato += questionario.toString();
        }
        return risultato;
    }
}
