/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.*;

public class CollezioneQuesiti {
    
    private String id;
    private String dtd;
    private String style;
    private String disciplina;
    private List listaQuesiti = new ArrayList();
    private HashMap mappaArgomenti = new HashMap();
    private HashMap mappaDifficolta = new HashMap();
        
    public String getId() {
        return this.id;
    }
    
    public void setId(String id) {
        this.id = id;
    }

    public String getDtd() {
        return this.dtd;
    }

    public void setDtd(String dtd) {
        this.dtd = dtd;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getDisciplina() {
        return disciplina;
    }
    
    public void setDisciplina(String disciplina) {
        this.disciplina = disciplina;
    }
        
    public int getNumeroArgomenti() {
        return mappaArgomenti.size();
    }

    public Collection getArgomenti() {
        return (mappaArgomenti.values());
    }
    
    public Argomento getArgomento(String id) {
        return (Argomento)mappaArgomenti.get(id);
    }
    
    public void addArgomento(Argomento argomento) {
        mappaArgomenti.put(argomento.getId(), argomento);
        argomento.setCollezioneQuesiti(this);
    }

    public void removeArgomento(String idArgomento) {
        mappaArgomenti.remove(idArgomento);
    }
    
    public int getNumeroDifficolta() {
        return mappaDifficolta.size();
    }

    public Collection getDifficoltas() {
        return (mappaDifficolta.values());
    }
        
    public Difficolta getDifficolta(String id) {
        return (Difficolta)mappaDifficolta.get(id);
    }
    
    public void removeDifficolta(String idDifficolta) {
        mappaDifficolta.remove(idDifficolta);
    }

    public void addDifficolta(Difficolta difficolta) {
        mappaDifficolta.put(difficolta.getId(), difficolta);
        difficolta.setCollezioneQuesiti(this);
    }

    public int getNumeroQuesiti() {
        return listaQuesiti.size();
    }
    
    public List getQuesiti() {
        return listaQuesiti;
    }
    
    public Quesito getQuesito(int i) {
        if (i < getNumeroQuesiti()) {
            return (Quesito)listaQuesiti.get(i);
        } else { 
            return null;
        }
    }

    public Quesito getQuesitoById(String id) {
        int numeroQuesiti = getNumeroQuesiti();
        for (int i = 0; i < numeroQuesiti; i++) {
            Quesito quesito = (Quesito)listaQuesiti.get(i);
            if (quesito.getId().equals(id)) {
                return quesito;
            }
        }
        return null;
    }

    public void addQuesito(Quesito quesito) {
        listaQuesiti.add(quesito);
    }
    
    public boolean verificaDiversi() {
        for (int i = 0; i < getNumeroQuesiti(); i++) {
            Quesito quesitoIesimo = getQuesito(i);
            if (contaOccorrenze(quesitoIesimo) > 1) {
                return false;
            }
        }
        return true;
    }
    
    private int contaOccorrenze(Quesito quesito) {
        int occorrenze = 0;
        for (int i = 0; i < getNumeroQuesiti(); i++) {
            Quesito quesitoIesimo = getQuesito(i);
            if (quesito.getId().equals(quesitoIesimo.getId())) {
                occorrenze++;
            }
        }
        return occorrenze;
    }
    
    public String toString() {
        String risultato = "";
        risultato += "----------------------------------------\n";
        risultato += "  " + getId() + "\n";
        risultato += "  " + getDtd() + "\n";
        risultato += "  " + getStyle() + "\n";
        risultato += "----------------------------------------\n";
        risultato += stringaArgomenti();
        risultato += stringaDifficolta();
        risultato += stringaQuesiti();
        risultato += "----------------------------------------\n";
        return risultato;
    }
    
    private String stringaArgomenti() {
        String risultato = "  --Argomenti:--\n";
        Collection argomenti = getArgomenti();
        Iterator iterator = argomenti.iterator();
        while (iterator.hasNext()) {
            Argomento argomento = (Argomento)iterator.next();
            risultato += "  "+argomento.getId()+" -- "+argomento.getNumeroQuesiti();
        }
        risultato += "\n";
        return risultato;
    }

    private String stringaDifficolta() {
        String risultato = "  --Difficolta:--\n";
        Collection difficoltas = getDifficoltas();
        Iterator iterator = difficoltas.iterator();
        while (iterator.hasNext()) {
            Difficolta difficolta = (Difficolta)iterator.next();
            risultato += "  "+difficolta.getId()+" -- "+difficolta.getNumeroQuesiti();
        }
        risultato += "\n";
        return risultato;
    }

    private String stringaQuesiti() {
        String risultato = "  --Quesiti:--\n";
        risultato += "  ";
        for (int i = 0; i < listaQuesiti.size(); i++) {
            risultato += ((Quesito)listaQuesiti.get(i)).toString() + "\n";
        }
        risultato += "\n";
        return risultato;
    }
    
    public CollezioneQuesiti copia() {
        CollezioneQuesiti copia = new CollezioneQuesiti();
        copiaAttributi(copia);
        copiaArgomenti(copia);
        copiaDifficolta(copia);
        copiaQuesiti(copia);
        return copia;
    }
    
    public void copiaAttributi (CollezioneQuesiti nuovaCollezione) {
        if (this.id != null) {
            nuovaCollezione.setId(new String(this.id));
        }
        if (this.dtd != null) {
            nuovaCollezione.setDtd(new String(this.dtd));
        }
        if (this.style != null) {
            nuovaCollezione.setStyle(new String(this.style));
        }
        if (this.disciplina != null) {
           nuovaCollezione.setDisciplina(new String(this.disciplina));        
        }
    }

    public void copiaArgomenti(CollezioneQuesiti nuovaCollezione) {
        Collection argomenti = this.getArgomenti();
        Iterator iterator = argomenti.iterator();
        while (iterator.hasNext()) {
            Argomento argomento = (Argomento)iterator.next();
            Argomento nuovoArgomento = argomento.copia();
            nuovaCollezione.addArgomento(nuovoArgomento);
        }
    }
    
    public void copiaDifficolta(CollezioneQuesiti nuovaCollezione) {
        Collection difficoltas = this.getDifficoltas();
        Iterator iterator = difficoltas.iterator();
        while (iterator.hasNext()) {
            Difficolta difficolta = (Difficolta)iterator.next();
            Difficolta nuovaDifficolta = difficolta.copia();
            nuovaCollezione.addDifficolta(nuovaDifficolta);
        }
    }

    public void copiaQuesiti(CollezioneQuesiti nuovaCollezione) {
        for (int i = 0; i < this.getNumeroQuesiti(); i++) {
            Quesito quesitoIesimo = this.getQuesito(i);
            Quesito copiaQuesito = quesitoIesimo.copia();
            nuovaCollezione.addQuesito(copiaQuesito);
        }
    }
    
}
