/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.List;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.HashMap;

public class Configurazione {
        
    private CollezioneQuesiti archivio;
    private String strategia = Utilita.STRATEGIA_CASUALE;
    private GenerazioneStrategy strategy;
    private int numeroGruppi;
    private int numeroPermutazioni;
    private int numeroQuesiti;
    private String cartellaDestinazione;
    private List listaArgomenti = new ArrayList();
    private HashMap mappaNumeroQuesiti = new HashMap();
        
    public CollezioneQuesiti getArchivio() {
        return archivio;
    }
    
    public void setArchivio(CollezioneQuesiti archivio) {
        this.archivio = archivio;
    }
    
    public String getStrategia() {
        return strategia;
    }
    
    public void setStrategia(String strategia) {
        this.strategia = strategia;
    }
    
    public GenerazioneStrategy getStrategy() {
        return strategy;
    }
    
    public void setStrategy(GenerazioneStrategy strategy) {
        this.strategy = strategy;
    }

    public int getNumeroGruppi() {
        return numeroGruppi;
    }

    public void setNumeroGruppi(int numeroGruppi) {
        this.numeroGruppi = numeroGruppi;
    }

    public int getNumeroPermutazioni() {
        return numeroPermutazioni;
    }

    public void setNumeroPermutazioni(int numeroPermutazioni) {
        this.numeroPermutazioni = numeroPermutazioni;
    }

    public int getNumeroQuesiti() {
        return numeroQuesiti;
    }

    public void setNumeroQuesiti(int numeroQuesiti) {
        this.numeroQuesiti = numeroQuesiti;
    }

    public String getCartellaDestinazione() {
        return cartellaDestinazione;
    }   
    
    public void setCartellaDestinazione(String cartellaDestinazione) {
        this.cartellaDestinazione = cartellaDestinazione;
    }

    public int getNumeroArgomenti() {
        return listaArgomenti.size();
    }
    
    public void setArgomenti(String argomenti) {
        if (argomenti != null && !argomenti.equals("")) {
            StringTokenizer st = new StringTokenizer(argomenti, ",");
            while (st.hasMoreTokens()) {
                String argomento = st.nextToken().trim();
                listaArgomenti.add(argomento);
            }
        }
    }
    
    public String getArgomento(int i) {
        if (i < listaArgomenti.size()) {
            return (String)listaArgomenti.get(i);
        } else {
            return null;
        }
    }
    
    public void addNumeroQuesiti(String idDifficolta, Integer numeroQuesiti) {
        mappaNumeroQuesiti.put(idDifficolta, numeroQuesiti);
    }

    public Integer getNumeroQuesiti(String idDifficolta) {
        return (Integer)mappaNumeroQuesiti.get(idDifficolta);
    }

    public void verifica() throws ConfigurazioneException {
        if (!verificaStrategia()) {
            throw new ConfigurazioneException("Valore scorretto della strategia");
        }
        GenerazioneStrategyFactory strategyFactory = GenerazioneStrategyFactory.getInstance();
        this.strategy = strategyFactory.getStrategy(this);
        String errori = strategy.verificaConfigurazione();
        if (!errori.equals("")) {
            throw new ConfigurazioneException(errori);
        }
    }

    public boolean verificaStrategia() {
        boolean verifica = false;
        if (strategia.equals(Utilita.STRATEGIA_CASUALE) || strategia.equals(Utilita.STRATEGIA_VINCOLATA)) {
            verifica = true;
        }
        return verifica;
    }
    
   public CollezioneQuesiti generaCollezioneQuesiti(String id) {
        return this.strategy.generaCollezioneQuesiti(id);
   }
    
}


