/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.List;
import java.util.ArrayList;

public class Difficolta {
    
    private String id;
    private String descrizione;
    private CollezioneQuesiti collezioneQuesiti;
    
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    
    public String getDescrizione() {
        return descrizione;
    }
    
    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }
    
    public CollezioneQuesiti getCollezioneQuesiti() {
        return this.collezioneQuesiti;
    }

    public void setCollezioneQuesiti(final CollezioneQuesiti collezioneQuesiti) {
        this.collezioneQuesiti = collezioneQuesiti;
    }

    public Difficolta copia() {
        Difficolta copia = new Difficolta();
        if (this.id != null) {
            copia.setId(new String(this.id));
        }
        if (this.descrizione != null) {
            copia.setDescrizione(new String(this.descrizione));
        }
        return copia;
    }
    
//-----------------------------
    
    public int getNumeroQuesiti() {
        return this.getListaQuesiti().size();
    }
    
    public List getListaQuesiti() {
        List risultato = new ArrayList();
        for (int i = 0; i < this.collezioneQuesiti.getNumeroQuesiti(); i++) {
            Quesito quesitoIesimo = this.collezioneQuesiti.getQuesito(i);
            if (quesitoIesimo.getIdDifficolta().equals(this.id)) {
                risultato.add(quesitoIesimo);
            }
        }
        return risultato;
    }
    
}
