/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.Collection;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

public abstract class GenerazioneStrategy {

   protected Configurazione configurazione;
   
   public GenerazioneStrategy(Configurazione configurazione){
        this.configurazione = configurazione;
   }
    
   public abstract CollezioneQuesiti generaCollezioneQuesiti(String id);
   
   public abstract String verificaConfigurazione();
   
   protected void selezioneCasuale(List listaQuesiti, 
                                  CollezioneQuesiti collezioneQuesiti, 
                                  int numeroQuesiti) {
        List copiaListaQuesiti = new LinkedList();
        copiaLista(listaQuesiti, copiaListaQuesiti);
        for (int i = 0; i < numeroQuesiti; i++) {
            int posizione = (int)(Math.random() * copiaListaQuesiti.size());
            Quesito quesito = (Quesito)copiaListaQuesiti.get(posizione);
            collezioneQuesiti.addQuesito(quesito.copia());
            copiaListaQuesiti.remove(posizione);
        }
    }

    public void mescolarisposte(CollezioneQuesiti collezioneQuesiti) {
        for (int i = 0; i < collezioneQuesiti.getNumeroQuesiti(); i++) {
            Quesito quesitoIesimo = collezioneQuesiti.getQuesito(i);
            mescolaRisposteQuesito(quesitoIesimo);
        }
    }
   
    private void mescolaRisposteQuesito(Quesito quesito) {
        for (int i = 0; i < quesito.getNumeroRisposte() * 2; i++) {
            List listaRisposte = quesito.getListaRisposte();
            String vecchiaSoluzione = quesito.getSoluzione();
            String nuovaSoluzione = scambia(listaRisposte, vecchiaSoluzione);
            quesito.setSoluzione(nuovaSoluzione);
        }
    }
    
    private String scambia (List lista, String soluzione) {
        int posizioneCorretta = (int)soluzione.charAt(0) - 97;
        //System.out.println("v. soluzione: " + soluzione);
        int posizione1 = (int)(Math.random() * lista.size());
        int posizione2 = (int)(Math.random() * lista.size());
        //System.out.println("scambio: " + posizione1 + " " + posizione2);
        Object temp = lista.get(posizione1);
        lista.set(posizione1, lista.get(posizione2));
        lista.set(posizione2, temp);
        String risultato = null;
        if (posizioneCorretta == posizione1) {
            risultato = new String("" + (char)(posizione2 + 97));
        } else if (posizioneCorretta == posizione2) {
            risultato = new String("" + (char)(posizione1 + 97));            
        } else {
            risultato = soluzione;
        }
        //System.out.println("nuova soluzione: " + risultato);
        return risultato;
    }
    
    public void copiaLista(List listaQuesiti, List rimanenti) {
        int numeroQuesiti = listaQuesiti.size();
        for (int i = 0; i < numeroQuesiti; i++) {
            Quesito quesito = (Quesito)listaQuesiti.get(i);
            rimanenti.add(quesito);
        }
    }

    public void eliminaDifficolta(CollezioneQuesiti collezioneQuesiti) {
        List daRimuovere = new LinkedList();
        Collection difficoltas = collezioneQuesiti.getDifficoltas();
        Iterator iterator = difficoltas.iterator();
        while (iterator.hasNext()) {
            Difficolta difficolta = (Difficolta)iterator.next();
            if (difficolta.getNumeroQuesiti() == 0) {
                daRimuovere.add(difficolta.getId());
            }
        }
        for (int i = 0; i < daRimuovere.size(); i++) {
            collezioneQuesiti.removeDifficolta((String)daRimuovere.get(i));
        }
    }
    
    public void eliminaArgomenti(CollezioneQuesiti collezioneQuesiti) {
        List daRimuovere = new LinkedList();
        Collection argomenti = collezioneQuesiti.getArgomenti();
        Iterator iterator = argomenti.iterator();
        while (iterator.hasNext()) {
            Argomento argomento = (Argomento)iterator.next();
            if (argomento.getNumeroQuesiti() == 0) {
                daRimuovere.add(argomento.getId());
            }
        }
        for (int i = 0; i < daRimuovere.size(); i++) {
            collezioneQuesiti.removeArgomento((String)daRimuovere.get(i));
        }
    }
    
}
