/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.*;

public class GenerazioneVincolata extends GenerazioneStrategy {

    private CollezioneQuesiti archivio;
    
    public GenerazioneVincolata(Configurazione configurazione) {
        super(configurazione);
    }
        
    private void generaArchivioRidotto() {
        CollezioneQuesiti archivio = configurazione.getArchivio();
        CollezioneQuesiti archivioRidotto = new CollezioneQuesiti();
        if (configurazione.getNumeroArgomenti() == 0) {
            archivioRidotto = archivio.copia();
        } else {
            archivio.copiaAttributi(archivioRidotto);
            archivio.copiaDifficolta(archivioRidotto);
            archivio.copiaArgomenti(archivioRidotto);
            int numeroArgomenti = configurazione.getNumeroArgomenti();
            for (int i = 0; i < numeroArgomenti; i++) {
                String idArgomento = configurazione.getArgomento(i);
                Argomento argomento = archivio.getArgomento(idArgomento);
                aggiungiQuesiti(archivioRidotto, argomento);
            }
        }
        this.archivio = archivioRidotto;
    }
        
    private void aggiungiQuesiti(CollezioneQuesiti archivioRidotto, Argomento argomento) {
        List listaQuesiti = argomento.getListaQuesiti();
        for (int i = 0; i < listaQuesiti.size(); i++) {
            Quesito quesito = (Quesito)listaQuesiti.get(i);
            archivioRidotto.addQuesito(quesito.copia());
        }        
    }

    public CollezioneQuesiti generaCollezioneQuesiti(String id) {
        CollezioneQuesiti collezioneQuesiti = generaCollezione(id);
        return collezioneQuesiti;
    }
    
    private CollezioneQuesiti generaCollezione(String id) {
        CollezioneQuesiti collezioneQuesiti = new CollezioneQuesiti();
        this.archivio.copiaAttributi(collezioneQuesiti);
        this.archivio.copiaArgomenti(collezioneQuesiti);
        this.archivio.copiaDifficolta(collezioneQuesiti);
        collezioneQuesiti.setId(id);
        inserisciQuesitiDifficolta(collezioneQuesiti);
        eliminaDifficolta(collezioneQuesiti);
        eliminaArgomenti(collezioneQuesiti);
        return collezioneQuesiti;
    }
    
    private void inserisciQuesitiDifficolta(CollezioneQuesiti collezioneQuesiti) {
        int numeroRimanenti = configurazione.getNumeroQuesiti();
        List rimanenti = new ArrayList();
        Collection difficoltas = this.archivio.getDifficoltas();
        Iterator iterator = difficoltas.iterator();
        while (iterator.hasNext()) {
            Difficolta difficolta = (Difficolta)iterator.next();
            List listaQuesitiD = difficolta.getListaQuesiti();
            Integer oggettoNumeroQuesiti = configurazione.getNumeroQuesiti(difficolta.getId());
            if (oggettoNumeroQuesiti != null) {
                int numeroQuesitiDaInserire = oggettoNumeroQuesiti.intValue();
                selezioneCasuale(listaQuesitiD, collezioneQuesiti, numeroQuesitiDaInserire); 
                numeroRimanenti -= numeroQuesitiDaInserire;
            } else {
                copiaLista(listaQuesitiD, rimanenti);
            }
        }
        if (rimanenti.size() != 0) {
            selezioneCasuale(rimanenti, collezioneQuesiti, numeroRimanenti);             
        }
        mescolarisposte(collezioneQuesiti);
    }
            
    public String verificaConfigurazione() {
        String errori = "";
        errori += verificaArgomenti();
        if (errori.equals("")) {
            generaArchivioRidotto();
            errori += verificaNumeroQuesiti();
        }
        return errori;
    }

    private String verificaArgomenti() {
        String errori = "";
        CollezioneQuesiti archivioOriginale = configurazione.getArchivio();
        int numeroArgomenti = configurazione.getNumeroArgomenti();
        for (int i = 0; i < numeroArgomenti; i++) {
            String idArgomento = configurazione.getArgomento(i);
            Argomento argomento = archivioOriginale.getArgomento(idArgomento);
            if (argomento == null) {
                errori += "- Argomento " + idArgomento + " inesistente\n";
            }
        }
        return errori;
    }
    
    private String verificaNumeroQuesiti() {
        String errori = "";
        int numeroQuesitiArchivio = this.archivio.getNumeroQuesiti();
        int numeroQuesitiQuestionario = configurazione.getNumeroQuesiti();
        for (int i = 0; i < Utilita.ID_DIFFICOLTA.length; i++) {
            Integer oggettoNumeroQuesiti = configurazione.getNumeroQuesiti(Utilita.ID_DIFFICOLTA[i]);
            if (oggettoNumeroQuesiti != null) {
                int numeroQuesitiDaInserire = oggettoNumeroQuesiti.intValue();
                Difficolta difficolta = this.archivio.getDifficolta(Utilita.ID_DIFFICOLTA[i]);
                if (difficolta == null) {
                    errori += "- Livello di difficolta' " + Utilita.ID_DIFFICOLTA[i] + " inesistente\n";                    
                } else {
                    int numeroQuesitiDifficolta = difficolta.getNumeroQuesiti();
                    if (numeroQuesitiDaInserire > numeroQuesitiDifficolta) {
                        errori += "- Numero quesiti di difficolta' "+difficolta.getId()+" insufficiente\n";
                    }
                    numeroQuesitiArchivio -= numeroQuesitiDifficolta;
                }
                numeroQuesitiQuestionario -= numeroQuesitiDaInserire;
            } 
        }
        if (numeroQuesitiQuestionario < 0) {
            errori += "- Il numero di quesiti per difficolta' e' superiore al numero totale\n";
        }        
        if (numeroQuesitiQuestionario > numeroQuesitiArchivio) {
            errori += "- Il numero dei quesiti nell'archivio e' insufficiente\n";
        }        
        return errori;
    }

    /*
    private int calcolaNumeroQuesitiArchivio() {
        int numeroQuesitiArchivio = 0;
        int numeroArgomenti = configurazione.getNumeroArgomenti();
        if (numeroArgomenti == 0) {
            CollezioneQuesiti archivio = configurazione.getArchivio();
            numeroQuesitiArchivio = archivio.getNumeroQuesiti();
        } else {
            for (int i = 0; i < numeroArgomenti; i++) {
                String idArgomento = configurazione.getArgomento(i);
                CollezioneQuesiti archivio = configurazione.getArchivio();
                Argomento argomento = archivio.getArgomento(idArgomento);
                if (argomento != null) {
                    numeroQuesitiArchivio += argomento.getNumeroQuesiti();
                }
            }
        }        
        return numeroQuesitiArchivio;
    }
    */
}
