/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.*;

public class GruppoQuestionari {
    
    private String id;
    private CollezioneQuesiti collezioneQuesiti;
    private Configurazione configurazione;
    private List listaPermutazioni = new ArrayList();
    
    public GruppoQuestionari(Configurazione configurazione, String id) {
        this.configurazione = configurazione;
        this.id = id;
        generaCollezioneQuesiti();
        generaPermutazioniQuesiti();
    }

    public void generaCollezioneQuesiti() {
        /*
        GenerazioneStrategyFactory factory = GenerazioneStrategyFactory.getInstance();
        String strategia = configurazione.getStrategia();
        GenerazioneStrategy generazioneStrategy = factory.getStrategy(configurazione);
        this.collezioneQuesiti = generazioneStrategy.generaCollezioneQuesiti(id);
         */
        this.collezioneQuesiti = configurazione.generaCollezioneQuesiti(id);
    }
    
    public void generaPermutazioniQuesiti() {
        int numeroQuesiti = collezioneQuesiti.getNumeroQuesiti();
        int[] permutazioneIdentica = new int[numeroQuesiti];
        for (int i = 0; i < numeroQuesiti; i++) {
            permutazioneIdentica[i] = i;
        }
        listaPermutazioni.add(permutazioneIdentica);
        int numeroPermutazioni = configurazione.getNumeroPermutazioni();
        for (int i = 0; i < numeroPermutazioni; i++) {
            addPermutazione();
        }
    }

    private void addPermutazione() {
        int numeroQuesiti = collezioneQuesiti.getNumeroQuesiti();
        int[] permutazione = new int[numeroQuesiti];
        for (int i = 0; i < numeroQuesiti; i++) {
            permutazione[i] = i;
        }
        generaScambi(permutazione);
        listaPermutazioni.add(permutazione);        
    }
    
    private void generaScambi(int[] permutazione) {
        int numeroQuesiti = collezioneQuesiti.getNumeroQuesiti();
        int numeroScambi = numeroQuesiti * 3 + 1;
        for (int i = 0; i < numeroScambi; i++) {
            int primo = (int)(Math.random()*numeroQuesiti);
            int secondo = (int)(Math.random()*numeroQuesiti);
            int tmp = permutazione[primo];
            permutazione[primo] = permutazione[secondo];
            permutazione[secondo] = tmp;
        }
    }
        
    public String getId() {
        return id;
    }
    
    public int getNumeroQuestionari() {
        return listaPermutazioni.size();
    }

    public CollezioneQuesiti getQuestionario(int i) {
        if (i < listaPermutazioni.size()) {
            CollezioneQuesiti questionario = new CollezioneQuesiti();
            collezioneQuesiti.copiaArgomenti(questionario);
            collezioneQuesiti.copiaDifficolta(questionario);
            questionario.setDisciplina(collezioneQuesiti.getDisciplina());
            questionario.setDtd(collezioneQuesiti.getDtd());
            questionario.setStyle(Utilita.STILE_QUESTIONARIO);
            questionario.setId(collezioneQuesiti.getId()+"-"+i);
            int[] permutazione = (int[])listaPermutazioni.get(i);
            for (int j = 0; j < collezioneQuesiti.getNumeroQuesiti(); j++) {
                Quesito quesito = collezioneQuesiti.getQuesito(permutazione[j]);
                questionario.addQuesito(quesito.copia());
            }
            return questionario;
        } else {
            return null;
        }
    }
    
}
