/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.modello;

import java.util.List;
import java.util.ArrayList;

public class Quesito {
    
    private String id;
    private String idArgomento;
    private String idDifficolta;
    private String soluzione;
    private List listaNodiDomanda = new ArrayList();
    private List listaRisposte = new ArrayList();
    
    public String getId() {
        return id;
    }
    
    public void setId(String id) {
        this.id = id;
    }

    public String getIdArgomento() {
        return idArgomento;
    }
    
    public void setIdArgomento(String idArgomento) {
        this.idArgomento = idArgomento;
    }
    
    public String getSoluzione() {
        return soluzione;
    }
    
    public void setSoluzione(String soluzione) {
        this.soluzione = soluzione;
    }
    
    public String getIdDifficolta() {
        return idDifficolta;
    }
    
    public void setIdDifficolta(String idDifficolta) {
        this.idDifficolta = idDifficolta;
    }

    public int getNumeroRisposte() {
        return this.listaRisposte.size();
    }
    
    public List getListaRisposte() {
        return this.listaRisposte;
    }
    
    public String getRisposta(int i) {
        if (i < listaRisposte.size()) {
            return (String)listaRisposte.get(i);
        } else {
            return null;
        }
    }

    public void addRisposta(String risposta) {
        this.listaRisposte.add(risposta);
    }

    public int getNumeroNodiDomanda() {
        return this.listaNodiDomanda.size();
    }
    
    public void addNodoDomanda(NodoDomanda nodoDomanda) {
        this.listaNodiDomanda.add(nodoDomanda);
    }
        
    public NodoDomanda getNodoDomanda(int i) {
        if (i < this.listaNodiDomanda.size()) {
            return (NodoDomanda)this.listaNodiDomanda.get(i);
        } else {
            return null;
        }
    }

    public String toString() {
        return "--id: "+id+"--sol: "+getSoluzione()+"--diff: "+getIdDifficolta() +
                           "--arg: "+getIdArgomento();
    }    

    public Quesito copia() {
        Quesito copia = new Quesito();
        if (this.id != null) {
            copia.setId(new String(this.id));
        }
        if (this.idArgomento != null) {
            copia.setIdArgomento(new String(this.idArgomento));
        }
        if (this.idDifficolta != null) {
            copia.setIdDifficolta(new String(this.idDifficolta));
        }
        if (this.soluzione != null) {
            copia.setSoluzione(new String(this.soluzione));
        }
        for (int i = 0; i < listaNodiDomanda.size(); i++) {
            NodoDomanda nodoIesimo = (NodoDomanda)this.listaNodiDomanda.get(i);
            copia.addNodoDomanda(nodoIesimo.copia());
        }
        for (int i = 0; i < listaRisposte.size(); i++) {
            String rispostaIesima = (String)this.listaRisposte.get(i);
            copia.addRisposta(new String(rispostaIesima));
        }
        return copia;
    }
}
