/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.persistenza;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.w3c.dom.*;
import it.unibas.pdd.modello.*;

class DAOCaricaXML {
    
    private Document documento;
    private CollezioneQuesiti collezioneQuesiti;
    private CollezioneProve collezioneProve;
     
    public CollezioneQuesiti caricaCollezioneQuesiti(String nomeFile) throws DAOException {
        generaDOM(nomeFile);
        Element radice = documento.getDocumentElement();
        collezioneQuesiti = new CollezioneQuesiti();
        generaDtdEStile(documento);
        generaCollezioneQuesiti(radice);
        return collezioneQuesiti;
    }

    public CollezioneProve caricaCollezioneProve(String nomeFile) throws DAOException {
        generaDOM(nomeFile);
        Element radice = documento.getDocumentElement();
        generaCollezioneProve(radice);
        return collezioneProve;
    }

    private void generaDOM(String nomeFile) throws DAOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        MioErrorHandler mioErrorHandler = new MioErrorHandler();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(mioErrorHandler);
            documento = builder.parse( new File(nomeFile) );
        } catch (ParserConfigurationException pce) {
            //System.err.println(pce);
            throw new DAOException(pce);
        } catch (SAXException sxe) {
            //System.err.println(sxe);
            throw new DAOException(sxe);
        } catch (IOException ioe) {
            //System.err.println(ioe);
            throw new DAOException(ioe);
        }
        if (!mioErrorHandler.isValido()) {
            throw new DAOException(mioErrorHandler.getErrori());
        }
    }
        
    private void generaDtdEStile(Document documento) {
        DocumentType documentType = documento.getDoctype();
        String systemId = documentType.getSystemId();
        collezioneQuesiti.setDtd(systemId);
        boolean continua = true;
        Node nodoTmp = documentType;
        while (continua) {
            nodoTmp = nodoTmp.getNextSibling();
            if (nodoTmp == null) {
                continua = false;
            } else if (nodoTmp.getNodeType() == Node.PROCESSING_INSTRUCTION_NODE &&
                       nodoTmp.getNodeValue().lastIndexOf("xsl") != -1) {
                continua = false;
            }
        }
        if (nodoTmp != null) {
            String styleRef = nodoTmp.getNodeValue();
            String style = styleRef.substring(styleRef.lastIndexOf("=\"") + 2, styleRef.lastIndexOf("\""));
            collezioneQuesiti.setStyle(style);
        } 
    }
    
    private void generaCollezioneQuesiti(Element radice) {
        String id = radice.getAttribute("id");
        String nomeDisciplina = radice.getAttribute("disciplina");
        collezioneQuesiti.setId(id);
        collezioneQuesiti.setDisciplina(nomeDisciplina);
        caricaListaArgomenti(radice);
        caricaListaDifficolta(radice);
        caricaListaQuesiti(radice);
    }
    
    private void caricaListaArgomenti(Element radice) {
        Element listaArgomenti = getFirstChildByName(radice, "listaArgomenti");
        NodeList argomenti = listaArgomenti.getElementsByTagName("argomento");
        for(int i = 0; i < argomenti.getLength(); i++){
            Element elementoArgomento = (Element)argomenti.item(i);
            Argomento argomento = caricaArgomento(elementoArgomento);
            collezioneQuesiti.addArgomento(argomento);
        }        
    }
    
    private Argomento caricaArgomento(Element elementoArgomento) {
        String id = elementoArgomento.getAttribute("id");
        String nome = elementoArgomento.getAttribute("nome");
        Argomento argomento = new Argomento();
        argomento.setId(id);
        argomento.setNome(nome);
        return argomento;
    }

    private void caricaListaDifficolta(Element radice) {
        Element listaDifficolta = getFirstChildByName(radice, "listaDifficolta");
        NodeList nldifficolta = listaDifficolta.getElementsByTagName("difficolta");
        for(int i = 0; i < nldifficolta.getLength(); i++){
            Element elementoDifficolta = (Element)nldifficolta.item(i);
            Difficolta difficolta = caricaDifficolta(elementoDifficolta);
            collezioneQuesiti.addDifficolta(difficolta);
        }        
    }
    
    private Difficolta caricaDifficolta(Element elementoDifficolta) {
        String id = elementoDifficolta.getAttribute("id");
        String descrizione = elementoDifficolta.getAttribute("descrizione");
        Difficolta difficolta = new Difficolta();
        difficolta.setId(id);
        difficolta.setDescrizione(descrizione);
        return difficolta;
    }

    private void caricaListaQuesiti(Element radice) {
        Element elencoQuesiti = getFirstChildByName(radice, "listaQuesiti");
        NodeList quesiti = elencoQuesiti.getElementsByTagName("quesito");
        for(int i = 0; i < quesiti.getLength(); i++){
            Element elementoQuesito = (Element)quesiti.item(i);
            Quesito quesito = caricaQuesito(elementoQuesito);
            collezioneQuesiti.addQuesito(quesito);
        }
    }

    private Quesito caricaQuesito(Element elementoQuesito) {
        String id = elementoQuesito.getAttribute("id");
        String idArgomento = elementoQuesito.getAttribute("argomento");
        String idDifficolta = elementoQuesito.getAttribute("difficolta");
        Quesito quesito = new Quesito();
        quesito.setId(id);
        quesito.setIdArgomento(idArgomento);
        quesito.setIdDifficolta(idDifficolta);
        caricaDomanda(elementoQuesito, quesito);
        caricaListaRisposte(elementoQuesito, quesito);
        return quesito;
    }
    
    private void caricaDomanda(Element elementoQuesito, Quesito quesito) {
        Element elementoDomanda = getFirstChildByName(elementoQuesito, "domanda");
        NodeList listaFigli = elementoDomanda.getChildNodes();
        for (int i = 0; i < listaFigli.getLength(); i++) {
            Node nodoI = listaFigli.item(i);
            int tipo = nodoI.getNodeType();
            NodoDomanda nodoDomanda = new NodoDomanda();
            quesito.addNodoDomanda(nodoDomanda);
            if (tipo == Node.TEXT_NODE) {
                nodoDomanda.setTipo("testo");
                String valore = nodoI.getNodeValue().trim();
                nodoDomanda.setValore(valore);
            } else if (tipo == Node.ELEMENT_NODE) {
                String nomeElemento = nodoI.getNodeName();
                nodoDomanda.setTipo(nomeElemento);
                Element elementoI = (Element)nodoI;
                Text testoDomanda = (Text)elementoI.getFirstChild();
                String valore = testoDomanda.getNodeValue();       
                nodoDomanda.setValore(valore);
            }
        }
    }
    
    private void caricaListaRisposte(Element elementoQuesito, Quesito quesito) {
        Element elencoRisposte = getFirstChildByName(elementoQuesito, "listaRisposte");
        String soluzione = elencoRisposte.getAttribute("soluzione");
        quesito.setSoluzione(soluzione);
        NodeList risposte = elencoRisposte.getElementsByTagName("risposta");
        for(int i = 0; i < risposte.getLength(); i++){
            Element elementoRisposta = (Element)risposte.item(i);
            Text testoRisposta = (Text)elementoRisposta.getFirstChild();
            String risposta = testoRisposta.getNodeValue().trim();
            quesito.addRisposta(risposta);
        }        
    }
       
    private Element getFirstChildByName(Element elemento, String nome) {
        NodeList figli = elemento.getChildNodes();
        for (int i = 0; i < figli.getLength(); i++) {
            Node figlio = figli.item(i);
            if (figlio.getNodeName().equals(nome)) {
                return (Element)figlio;
            }
        }
        return null;
    }
    
    private CollezioneProve generaCollezioneProve(Element radice) {
        // ********************
        return null;
    }
    
}
        