/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.persistenza;

import java.util.*;
import java.io.*;
import it.unibas.pdd.modello.*;

public class DAOConfigurazione {
    
    private static DAOConfigurazione singleton;
    
    private DAOConfigurazione() {}
    
    public static DAOConfigurazione getInstance() {
        if (singleton == null)
            singleton = new DAOConfigurazione();
        return singleton;
    }
    
    public Configurazione carica(String nomeFile) throws DAOException, ConfigurazioneException {
        Properties proprieta = caricaProperties(nomeFile);
        Configurazione configurazione = new Configurazione();
        caricaArchivio(proprieta, configurazione);
        String cartellaDestinazione = proprieta.getProperty("cartellaDestinazione");
        configurazione.setCartellaDestinazione(cartellaDestinazione);
        caricaConfigurazioneGruppi(proprieta, configurazione);
        String strategia = proprieta.getProperty("strategia");
        configurazione.setStrategia(strategia);
        if (strategia.equals(Utilita.STRATEGIA_VINCOLATA)) {
            String argomenti = proprieta.getProperty("elencoArgomenti");
            configurazione.setArgomenti(argomenti);
            caricaDistribuzioneDifficolta(proprieta, configurazione);
        }
        configurazione.verifica();
        return configurazione;
    }

    private Properties caricaProperties (String nomeFile) throws DAOException {
        Properties proprieta = new Properties();
        File file = new File(nomeFile);
        try {
            proprieta.load(new FileInputStream(file));
        } catch (FileNotFoundException fnfe) {
            System.err.println(fnfe);
            throw new DAOException("File di configurazione inesistente");
        } catch (IOException ioe) {
            System.err.println(ioe);
            throw new DAOException("Impossibile caricare la configurazione");
        }
        return proprieta;
    }
    
    private void caricaArchivio(Properties proprieta, Configurazione configurazione) 
                         throws DAOException {
        String nomeFileArchivio = proprieta.getProperty("archivio");
        CollezioneQuesiti archivio;
        try {
            archivio = DAOXML.getInstance().caricaCollezioneQuesiti(nomeFileArchivio);
        } catch (DAOException daoe) {
            System.err.println(daoe);
            throw new DAOException("Impossibile caricare l'archivio");
        }
        configurazione.setArchivio(archivio);        
    }
    
    private void caricaConfigurazioneGruppi(Properties proprieta, 
                                            Configurazione configurazione) 
                                     throws DAOException {
        int numeroGruppi;
        int numeroPermutazioni;
        int numeroQuesiti;
        try {
            numeroGruppi = Integer.parseInt(proprieta.getProperty("numeroGruppi"));
            numeroPermutazioni = Integer.parseInt(proprieta.getProperty("numeroPermutazioni"));
            numeroQuesiti = Integer.parseInt(proprieta.getProperty("numeroQuesiti"));
        } catch (NumberFormatException nfe) {
            System.err.println(nfe);
            throw new DAOException("Configurazione scorretta per la collezione di prove");
        }
        configurazione.setNumeroGruppi(numeroGruppi);
        configurazione.setNumeroPermutazioni(numeroPermutazioni);
        configurazione.setNumeroQuesiti(numeroQuesiti);        
    }

    private void caricaDistribuzioneDifficolta(Properties proprieta, 
                                               Configurazione configurazione) 
                                        throws DAOException {
        String base = "numeroQuesiti";
        for (int i = 0; i < Utilita.ID_DIFFICOLTA.length; i++) {
            String numeroQuesitiD = proprieta.getProperty(base + Utilita.ID_DIFFICOLTA[i]);
            int valore;
            //if (numeroQuesitiD == null) {
            //    throw new DAOException("Proprieta' mancante: numero di quesiti " + 
            //                            Utilita.ID_DIFFICOLTA[i]);                
            //} 
            if (numeroQuesitiD != null && !numeroQuesitiD.equals("")) {
                try {
                    valore = Integer.parseInt(numeroQuesitiD);
                } catch (NumberFormatException nfe) {
                    System.err.println(nfe);
                    throw new DAOException("Numero di quesiti " +
                                            Utilita.ID_DIFFICOLTA[i] + " scorretto");
                }
                configurazione.addNumeroQuesiti(Utilita.ID_DIFFICOLTA[i], new Integer(numeroQuesitiD));
            }
        }    
    }    
    
}
