/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.persistenza;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.w3c.dom.*;
import it.unibas.pdd.modello.*;
import java.util.HashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class DAOSalvaXML {
    
    private Document documento;
    private CollezioneQuesiti collezioneQuesiti;
    private CollezioneProve collezioneProve;

    public void salvaCollezioneQuesiti(CollezioneQuesiti collezioneQuesiti, String nomeFile) throws DAOException {
        this.collezioneQuesiti = collezioneQuesiti;
        creaDOM();
        costruisciDOM();
        salvaDOM(nomeFile);
    }
    
    public void salvaCollezioneProve(String nomeFile) throws DAOException {
        /**** da completare  ***/
    }
    
    private void creaDOM() throws DAOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            documento = builder.newDocument();
            //DOMImplementation domImplementation = builder.getDOMImplementation();
            //DocumentType documentType = domImplementation.createDocumentType("collezioneQuesiti", null, "PdD-collezioneQuesiti-0-4.dtd");
            //documento = domImplementation.createDocument(null, "collezioneQuesiti", documentType);
            ProcessingInstruction stylesheet = documento.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + Utilita.STILE_QUESTIONARIO + "\"");
            documento.appendChild(stylesheet);
        } catch (ParserConfigurationException pce) {
            System.err.println(pce);
            throw new DAOException(pce);
        } catch (DOMException doe) {
            System.err.println(doe);
            throw new DAOException(doe);
        }
    }
         
    private void costruisciDOM() {
        //Element radice = documento.getDocumentElement();
        Element radice = (Element)documento.createElement("collezioneQuesiti");
        documento.appendChild(radice);
        Attr id = documento.createAttribute("id");
        id.setValue(collezioneQuesiti.getId());
        radice.setAttributeNode(id);
        Attr disciplina = documento.createAttribute("disciplina");
        disciplina.setValue(collezioneQuesiti.getDisciplina());
        radice.setAttributeNode(disciplina);
        costruisciListaArgomenti(radice);
        costruisciListaDifficolta(radice);
        costruisciListaQuesiti(radice);
    }
    
    private void costruisciListaArgomenti(Element radice) {
        Text invio1 = documento.createTextNode("\n");
        radice.appendChild(invio1);
        Element listaArgomenti = documento.createElement("listaArgomenti");
        radice.appendChild(listaArgomenti);   
        Collection argomenti = collezioneQuesiti.getArgomenti();
        Iterator iterator = argomenti.iterator();
        while (iterator.hasNext()) {
            Argomento argomento = (Argomento)iterator.next();
            Element elementoArgomento = documento.createElement("argomento");
            Attr id = documento.createAttribute("id");
            id.setValue(argomento.getId());
            elementoArgomento.setAttributeNode(id);
            Attr nome = documento.createAttribute("nome");
            nome.setValue(argomento.getNome());
            elementoArgomento.setAttributeNode(nome);            
            Text invio2 = documento.createTextNode("\n");
            listaArgomenti.appendChild(invio2);
            listaArgomenti.appendChild(elementoArgomento);
        }
        Text invio3 = documento.createTextNode("\n");
        listaArgomenti.appendChild(invio3);
        Text invio4 = documento.createTextNode("\n");
        radice.appendChild(invio4);
    }
    
    private void costruisciListaDifficolta(Element radice) {
        Text invio = documento.createTextNode("\n");
        radice.appendChild(invio);
        Element listaDifficolta = documento.createElement("listaDifficolta");
        radice.appendChild(listaDifficolta);
        Collection difficoltas = collezioneQuesiti.getDifficoltas();
        Iterator iterator = difficoltas.iterator();
        while (iterator.hasNext()) {
            Difficolta difficolta = (Difficolta)iterator.next();
            Element elementoDifficolta = documento.createElement("difficolta");
            Attr id = documento.createAttribute("id");
            id.setValue(difficolta.getId());
            elementoDifficolta.setAttributeNode(id);
            Attr descrizione = documento.createAttribute("descrizione");
            descrizione.setValue(difficolta.getDescrizione());
            elementoDifficolta.setAttributeNode(descrizione);            
            Text invio2 = documento.createTextNode("\n");
            listaDifficolta.appendChild(invio2);
            listaDifficolta.appendChild(elementoDifficolta);
        }
        Text invio3 = documento.createTextNode("\n");
        listaDifficolta.appendChild(invio3);
        Text invio4 = documento.createTextNode("\n");
        radice.appendChild(invio4);
    }

    private void costruisciListaQuesiti(Element radice) {
        Text invio1 = documento.createTextNode("\n");
        radice.appendChild(invio1);
        Element listaQuesiti = documento.createElement("listaQuesiti");
        radice.appendChild(listaQuesiti); 
        int numeroQuesiti = collezioneQuesiti.getNumeroQuesiti();
        for (int i = 0; i < numeroQuesiti; i++) {
            Quesito quesito = collezioneQuesiti.getQuesito(i);
            Element elementoQuesito = documento.createElement("quesito");
            costruisciQuesito(elementoQuesito, quesito);
            Text invio2 = documento.createTextNode("\n");
            listaQuesiti.appendChild(invio2);
            listaQuesiti.appendChild(elementoQuesito);
        }
        Text invio3 = documento.createTextNode("\n");
        listaQuesiti.appendChild(invio3);
        Text invio4 = documento.createTextNode("\n");
        radice.appendChild(invio4);
    }
    
    private void costruisciQuesito(Element elementoQuesito, Quesito quesito) {
        Attr id = documento.createAttribute("id");
        id.setValue(quesito.getId());
        elementoQuesito.setAttributeNode(id);
        Attr argomento = documento.createAttribute("argomento");
        argomento.setValue(quesito.getIdArgomento());
        elementoQuesito.setAttributeNode(argomento);
        Attr difficolta = documento.createAttribute("difficolta");
        difficolta.setValue(quesito.getIdDifficolta());
        elementoQuesito.setAttributeNode(difficolta);
        Element elementoDomanda = documento.createElement("domanda");
        Text invio1 = documento.createTextNode("\n");
        elementoQuesito.appendChild(invio1);
        elementoQuesito.appendChild(elementoDomanda);
        costruisciDomanda(elementoDomanda, quesito);
        Text invio3 = documento.createTextNode("\n");
        elementoDomanda.appendChild(invio3);
        costruisciListaRisposte(elementoQuesito, quesito);
        Text invio4 = documento.createTextNode("\n");
        elementoQuesito.appendChild(invio4);
    }
    
    private void costruisciDomanda(Element elementoDomanda, Quesito quesito) {
        for (int i = 0; i < quesito.getNumeroNodiDomanda(); i++) {
            Text invio = documento.createTextNode("\n");
            elementoDomanda.appendChild(invio);
            NodoDomanda nodoDomandaI = (NodoDomanda)quesito.getNodoDomanda(i);
            if (nodoDomandaI.getTipo().equals("testo")) {
                Text testo = documento.createTextNode(nodoDomandaI.getValore());        
                elementoDomanda.appendChild(testo);
            } else {
                Element elemento = documento.createElement(nodoDomandaI.getTipo());
                elementoDomanda.appendChild(elemento);
                Text invio2 = documento.createTextNode("\n");
                elemento.appendChild(invio2);
                Text testo = documento.createTextNode(nodoDomandaI.getValore());        
                elemento.appendChild(testo);
                Text invio3 = documento.createTextNode("\n");
                elemento.appendChild(invio3);
            }
            Text invio4 = documento.createTextNode("\n");
            elementoDomanda.appendChild(invio4);
        }
    }
    
    private void costruisciListaRisposte(Element elementoQuesito, Quesito quesito) {
        Element listaRisposte = documento.createElement("listaRisposte");
        Attr soluzione = documento.createAttribute("soluzione");
        soluzione.setValue(quesito.getSoluzione());
        listaRisposte.setAttributeNode(soluzione);
        Text invio1 = documento.createTextNode("\n");
        elementoQuesito.appendChild(invio1);
        elementoQuesito.appendChild(listaRisposte);
        int numeroRisposte = quesito.getNumeroRisposte();
        for (int i = 0; i < numeroRisposte; i++) {
            Text invio2 = documento.createTextNode("\n");
            listaRisposte.appendChild(invio2);
            Element elementoRisposta = documento.createElement("risposta");
            Text risposta = documento.createTextNode(quesito.getRisposta(i));
            elementoRisposta.appendChild(risposta);
            listaRisposte.appendChild(elementoRisposta);
        }        
        Text invio3 = documento.createTextNode("\n");
        listaRisposte.appendChild(invio3);
    }
    
    private void salvaDOM(String nomeFile) throws DAOException {
        try {
            File file = new File(nomeFile);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM, collezioneQuesiti.getDtd());
            DOMSource source = new DOMSource(documento);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        } catch (TransformerConfigurationException tce) {
            System.err.println(tce);
            throw new DAOException(tce);
        } catch (TransformerException te) {
            System.err.println(te);
            throw new DAOException(te);
        }
    }
        
}