/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.persistenza;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import it.unibas.pdd.modello.*;

public class DAOXML {
    
    private static DAOXML singleton;
    private DAOCaricaXML daoCaricaXml = new DAOCaricaXML();
    private DAOSalvaXML daoSalvaXml = new DAOSalvaXML();
    
    private DAOXML() {}
    
    public static DAOXML getInstance() {
        if (singleton == null)
            singleton = new DAOXML();
        return singleton;
    }

    public CollezioneQuesiti caricaCollezioneQuesiti(String nomeFile) throws DAOException {
        return daoCaricaXml.caricaCollezioneQuesiti(nomeFile);
    }
    
    public void salvaCollezioneQuesiti(CollezioneQuesiti collezioneQuesiti, 
                                        String nomeFile) throws DAOException {
        daoSalvaXml.salvaCollezioneQuesiti(collezioneQuesiti, nomeFile);
    }

    public void stampaQuestionariSuFile(CollezioneProve collezioneProve, 
                                        String percorso) throws DAOException {
        File cartella = new File(percorso);
        cartella.mkdirs();
        CollezioneQuesiti questionario = collezioneProve.getGruppoQuestionari(0).getQuestionario(0);
        String dtd = questionario.getDtd();
        String style = questionario.getStyle();
        copiaDtdEStile(dtd, style, percorso);
        for (int i = 0; i < collezioneProve.getNumeroGruppi(); i++) {
            GruppoQuestionari gruppoQuestionari = collezioneProve.getGruppoQuestionari(i);
            for (int j = 0; j < gruppoQuestionari.getNumeroQuestionari(); j++) {
                questionario = gruppoQuestionari.getQuestionario(j);
                salvaCollezioneQuesiti(questionario, percorso+"\\"+questionario.getId()+".xml");
            }
        }
    }

    private void copiaDtdEStile(String dtd, String style, String percorso) throws DAOException {
        try {
            java.net.URL url = this.getClass().getResource(dtd);
            File sorgenteDtd = new File(url.getPath());
            File destinazioneDtd = new File(percorso + File.separatorChar + dtd);
            copiaFile(sorgenteDtd, destinazioneDtd);
            java.net.URL url2 = this.getClass().getResource(style);
            File sorgenteStile = new File(url2.getPath());
            File destinazioneStile = new File(percorso + File.separatorChar + style);
            copiaFile(sorgenteStile, destinazioneStile);
        } catch (FileNotFoundException fnfe) {
            System.err.println(fnfe);
            throw new DAOException(fnfe);            
        } catch (IOException ioe) {
            throw new DAOException(ioe);
        } 
    }
    
    private void copiaFile(File source, File dest) throws IOException {
        BufferedInputStream in= null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            copyStream(in, out);
        } finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
    
    private void copyStream (InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int numberRead;
        while ((numberRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, numberRead);
        }
    }
    
}

