<?xml version="1.0" ?>

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="collezioneQuesiti">
        <html>
        <head>
            <title>Test <xsl:value-of select="@id"/></title>
            <style type="text/css">
               body {
                    font-size: 0.9em;
               }
               span.titolo {
                    font-weight: bold;
                    font-size: 1.2em;
                    font-family: Arial;
               }
               span.mini {
                    font-size: 0.8em;
               }
               h3 {
                    font-family: Arial;
                    font-size: 1em;
               }
               ol.risposte {
                    margin-top: 0.2em;
               }
               li.risposta {
                    list-style-type: lower-alpha;
               }
               li.quesito {
                    margin-top: 1em;
                    page-break-inside: avoid;
               }
               pre {
                    margin-top: 0em;
                    margin-bottom: 0.3em;
                    padding-top: 0em;
                    padding-left: 1em;
                    font-weight: normal;
               }    
               code {
                    font-weight: normal;
               }
            </style>
        </head>
        <body>
        <div>
        <span class="titolo">Domande a Risposta Multipla</span> - 
        <span class="mini"><xsl:value-of select="@id" /></span>
        </div>
        <h3>Cognome e Nome: __________________________ Matricola: ____________ </h3>
        <ol>
            <xsl:apply-templates />
        </ol>
        </body>
        </html>
    </xsl:template>

    <xsl:template match="quesito">
        <li class="quesito">
            <span>(Difficolta': <strong><xsl:value-of select="@difficolta" /></strong>)</span>
            <xsl:apply-templates />
        </li>
    </xsl:template>
    
    <xsl:template match="domanda">
        <b> 
            <xsl:apply-templates />
        </b>
    </xsl:template>

    <xsl:template match="listaRisposte">
        <ol class="risposte">
            <xsl:apply-templates />
        </ol>
    </xsl:template>

    <xsl:template match="risposta">
        <li class="risposta">
            <xsl:apply-templates />
        </li>
    </xsl:template>

    <xsl:template match="blocco">
        <pre>
            <xsl:apply-templates />
        </pre>
    </xsl:template>

    <xsl:template match="codice">
        <code>
            <xsl:apply-templates />
        </code>
    </xsl:template>

</xsl:stylesheet>