/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import it.unibas.pdd.modello.*;

public class TestCollezioneQuesiti extends TestCase {
    
    public TestCollezioneQuesiti(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestCollezioneQuesiti.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    CollezioneQuesiti collezioneQuesiti;
    
    protected void setUp() {
        collezioneQuesiti = new CollezioneQuesiti();
        collezioneQuesiti.setId("test");
        collezioneQuesiti.setDtd("test");
        collezioneQuesiti.setStyle("test");
        collezioneQuesiti.setDisciplina("test");        
        Difficolta difficolta0 = new Difficolta();
        difficolta0.setId("d0");
        Difficolta difficolta1 = new Difficolta();
        difficolta1.setId("d1");
        Difficolta difficolta2 = new Difficolta();
        difficolta2.setId("d2");
        collezioneQuesiti.addDifficolta(difficolta0);
        collezioneQuesiti.addDifficolta(difficolta1);
        collezioneQuesiti.addDifficolta(difficolta2);
        Argomento argomentoCap = new Argomento();
        argomentoCap.setId("cap");
        Argomento argomentoNaz = new Argomento();
        argomentoNaz.setId("naz");
        collezioneQuesiti.addArgomento(argomentoCap);
        collezioneQuesiti.addArgomento(argomentoNaz);
        Quesito quesito;
        quesito = creaQuesito("cap01", "cap", "d0");
        collezioneQuesiti.addQuesito(quesito);
        quesito = creaQuesito("cap02", "cap", "d1");
        collezioneQuesiti.addQuesito(quesito);
        quesito = creaQuesito("naz01", "naz", "d1");
        collezioneQuesiti.addQuesito(quesito);
    }

    private Quesito creaQuesito(String codiceQuesito, 
                            String codiceArgomento, 
                            String codiceDifficolta) {
        Quesito quesito = new Quesito();
        quesito.setId(codiceQuesito);
        quesito.setIdDifficolta(codiceDifficolta);
        quesito.setIdArgomento(codiceArgomento);
        NodoDomanda nodoDomanda = new NodoDomanda();
        nodoDomanda.setTipo("testo");
        nodoDomanda.setValore("Domanda da fare ?");
        quesito.addNodoDomanda(nodoDomanda);
        quesito.setSoluzione("b");
        quesito.addRisposta("risposta a");
        quesito.addRisposta("risposta b");
        quesito.addRisposta("risposta c");    
        return quesito;
    }
        
    public void testCollezioneQuesiti1() {
        assertTrue("n. argomenti", collezioneQuesiti.getNumeroArgomenti() == 2);
        assertTrue("n. difficolta", collezioneQuesiti.getNumeroDifficolta() == 3);
        assertTrue("n. quesiti", collezioneQuesiti.getNumeroQuesiti() == 3);
        int numeroQuesitiCap = collezioneQuesiti.getArgomento("cap").getNumeroQuesiti();
        assertTrue("n. quesiti cap", numeroQuesitiCap == 2);
        int numeroQuesitiNaz = collezioneQuesiti.getArgomento("naz").getNumeroQuesiti();
        assertTrue("n. quesiti naz", numeroQuesitiNaz == 1);
        int numeroQuesitid0 = collezioneQuesiti.getDifficolta("d0").getNumeroQuesiti();
        assertTrue("n. quesiti d0", numeroQuesitid0 == 1);
        int numeroQuesitid1 = collezioneQuesiti.getDifficolta("d1").getNumeroQuesiti();
        assertTrue("n. quesiti d1", numeroQuesitid1 == 2);
        int numeroQuesitid2 = collezioneQuesiti.getDifficolta("d2").getNumeroQuesiti();
        assertTrue("n. quesiti d2", numeroQuesitid2 == 0);
    }

    public void testGetQuesito1() {
        Quesito quesito = collezioneQuesiti.getQuesito(0);
        assertTrue("quesito 0", quesito.getId().equals("cap01"));
        quesito = collezioneQuesiti.getQuesito(2);
        assertTrue("quesito 2", quesito.getId().equals("naz01"));
        quesito = collezioneQuesiti.getQuesito(3);
        assertTrue("quesito nullo", quesito == null);
    }

    public void testGetQuesito2() {
        Quesito quesito = collezioneQuesiti.getQuesito(100);
        assertTrue("quesito nullo", quesito == null);
    }

    public void testGetQuesitoById1() {
        Quesito quesito = collezioneQuesiti.getQuesitoById("cap01");
        assertTrue("quesito cap01", quesito.getId().equals("cap01"));
        quesito = collezioneQuesiti.getQuesitoById("cap02");
        assertTrue("quesito cap02", quesito.getId().equals("cap02"));
    }

    public void testGetQuesitoById2() {
        Quesito quesito = collezioneQuesiti.getQuesitoById("xyxawe");
        assertTrue("quesito nullo", quesito == null);
    }

    public void testCopia() {
        CollezioneQuesiti copia = collezioneQuesiti.copia(); 
        assertTrue("id1", copia.getId().equals(collezioneQuesiti.getId()));
        assertTrue("id2", copia.getId() != collezioneQuesiti.getId());
        assertTrue("dtd1", copia.getDtd().equals(collezioneQuesiti.getDtd()));
        assertTrue("dtd2", copia.getDtd() != collezioneQuesiti.getDtd());
        assertTrue("style1", copia.getStyle().equals(collezioneQuesiti.getStyle()));
        assertTrue("style2", copia.getStyle() != collezioneQuesiti.getStyle());
        assertTrue("disc1", copia.getDisciplina().equals(collezioneQuesiti.getDisciplina()));
        assertTrue("disc2", copia.getDisciplina() != collezioneQuesiti.getDisciplina());
        assertTrue("num. arg", copia.getNumeroArgomenti() == collezioneQuesiti.getNumeroArgomenti());
        assertTrue("arg. cap", copia.getArgomento("cap") != collezioneQuesiti.getArgomento("cap"));
        assertTrue("num. diff", copia.getNumeroDifficolta() == collezioneQuesiti.getNumeroDifficolta());
        assertTrue("diff. d0", copia.getDifficolta("d0") != collezioneQuesiti.getDifficolta("d0"));
        assertTrue("num. q.", copia.getNumeroQuesiti() == collezioneQuesiti.getNumeroQuesiti());
        assertTrue("quesito 0a", copia.getQuesito(0) != collezioneQuesiti.getQuesito(0));
        assertTrue("quesito 0b", copia.getQuesito(0).getId().equals(collezioneQuesiti.getQuesito(0).getId()));        
    }
}

