/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import it.unibas.pdd.modello.Configurazione;
import it.unibas.pdd.persistenza.DAOConfigurazione;

public class TestConfigurazione extends TestCase {
    
    public TestConfigurazione(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestConfigurazione.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    String nomeFile1 = Costanti.NOME_FILE_1;
    String nomeFile2 = Costanti.NOME_FILE_2;
    String nomeFile3 = Costanti.NOME_FILE_3;
    String nomeFile4 = Costanti.NOME_FILE_4;
    String nomeFile5 = Costanti.NOME_FILE_5;
    Configurazione configurazione;
    
    protected void setUp() {
        configurazione = new Configurazione();
    }
    
    public void testArgomenti() {
        configurazione.setArgomenti("aaa, b, ccccc");
        assertTrue("numero argomenti", configurazione.getNumeroArgomenti() == 3);
        assertTrue("argomento 0", configurazione.getArgomento(0).equals("aaa"));
        assertTrue("argomento 1", configurazione.getArgomento(1).equals("b"));
        assertTrue("argomento 2", configurazione.getArgomento(2).equals("ccccc"));
        assertTrue("argomento 3", configurazione.getArgomento(3) == null);
    }
    
    public void testVerifica() {
        Configurazione configurazione = null;
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile5);
            configurazione.verifica();
            fail();
        } catch (Exception e) {
            System.err.println(e);
        }
    }
    
}
