/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import it.unibas.pdd.persistenza.*;
import it.unibas.pdd.modello.*;

public class TestDAOXML extends TestCase {
    
    public TestDAOXML(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestDAOXML.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    DAOXML daoxml;
    String percorso = Costanti.PERCORSO;
    String nomeFile25 = Costanti.ARCHIVIO_25;
    String nomeFile1 = Costanti.ARCHIVIO_1; 
    String nomeFile2 = Costanti.ARCHIVIO_2;
    String nomeFile3 = Costanti.ARCHIVIO_3;
    String nomeFile4 = Costanti.ARCHIVIO_4;
    
    protected void setUp() {
        daoxml = DAOXML.getInstance();
    }
    
    public void testCaricaCollezioneQuesiti1() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile1);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        verificaCollezione(collezioneQuesiti, "archivio", "Disciplina di prova", 1, 3, 1);
    }
        
    public void testCaricaCollezioneQuesiti2() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile2);
            fail();
        } catch (DAOException daoe) {
            assertTrue(daoe != null);
            System.err.println(daoe);
        }
    }

    public void testCaricaCollezioneQuesiti3() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile3);
            fail();
        } catch (DAOException daoe) {
            assertTrue(daoe != null);
            System.err.println(daoe);
        }
    }

    public void testCaricaCollezioneQuesiti4() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile4);
            fail();
        } catch (DAOException daoe) {
            assertTrue(daoe != null);
            System.err.println(daoe);
        }
    }

    public void testCaricaCollezioneQuesiti25() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile25);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        verificaCollezione(collezioneQuesiti, "geo", "Geografia", 3, 3, 25);
        Quesito quesito = null;
        quesito = collezioneQuesiti.getQuesito(15);
        assertTrue("numero nodi > 1", quesito.getNumeroNodiDomanda() == 3);
        assertTrue("primo nodo", quesito.getNodoDomanda(0).getTipo().equals("testo"));
        assertTrue("secondo nodo", quesito.getNodoDomanda(1).getTipo().equals("blocco"));
        assertTrue("terzo nodo", quesito.getNodoDomanda(2).getTipo().equals("testo"));
        quesito = collezioneQuesiti.getQuesito(14);
        assertTrue("numero nodi = 1", quesito.getNumeroNodiDomanda() == 1);
    }

    
    public void testCaricaArgomento1() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile1);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Argomento argomento = collezioneQuesiti.getArgomento("yyy");
        verificaArgomento(argomento, "yyy", "YYY", 1);
    }

    public void testCaricaArgomento2() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile25);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Argomento argomento = collezioneQuesiti.getArgomento("naz");
        verificaArgomento(argomento, "naz", "Nazioni Europee", 8);
    }
    
    public void testCaricaDifficolta1() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile1);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Difficolta difficolta = collezioneQuesiti.getDifficolta("d1");
        verificaDifficolta(difficolta, "d1", "Domanda di difficolta' media", 1);
        difficolta = collezioneQuesiti.getDifficolta("d2");
        verificaDifficolta(difficolta, "d2", "Domanda di difficolta' avanzata", 0);
    }

    public void testCaricaDifficolta2() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile25);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Difficolta difficolta = collezioneQuesiti.getDifficolta("d1");
        verificaDifficolta(difficolta, "d1", "Domanda di difficolta' media", 14);
        difficolta = collezioneQuesiti.getDifficolta("d2");
        verificaDifficolta(difficolta, "d2", "Domanda di difficolta' avanzata", 5);
    }

    public void testCaricaQuesito1() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile1);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Quesito quesito = collezioneQuesiti.getQuesito(0);
        verificaQuesito(quesito, "xxx", "Questo e' il testo della domanda ?", 4,
                        "aaa", "bbb", "ccc", "b", "yyy", "d1");
        assertTrue("risposta d", quesito.getRisposta(3).equals("ddd"));
        assertTrue("risposta e", quesito.getRisposta(4) == null);
    }

    public void testCaricaQuesito2() {
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile25);
        } catch (DAOException daoe) {
            System.err.println(daoe);
        }
        Quesito quesito = collezioneQuesiti.getQuesito(2);
        verificaQuesito(quesito, "cap03", "Qual e' la capitale del Regno Unito ?", 3,
                        "Il Cairo", "Roma", "Londra - esatta", "c", "cap", "d2");
    }    

    public void testSalvaCollezioneQuesiti1(){
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile1);
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        try {
            daoxml.salvaCollezioneQuesiti(collezioneQuesiti, percorso+"it\\unibas\\pdd\\test\\provaSalvataggioCQ1.xml");
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(percorso+"it\\unibas\\pdd\\test\\provaSalvataggioCQ1.xml");
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        verificaCollezione(collezioneQuesiti, "archivio", "Disciplina di prova", 1, 3, 1);
        Argomento argomento = collezioneQuesiti.getArgomento("yyy");
        verificaArgomento(argomento, "yyy", "YYY", 1);
        Difficolta difficolta = collezioneQuesiti.getDifficolta("d1");
        verificaDifficolta(difficolta, "d1", "Domanda di difficolta' media", 1);
        difficolta = collezioneQuesiti.getDifficolta("d2");
        verificaDifficolta(difficolta, "d2", "Domanda di difficolta' avanzata", 0);
        Quesito quesito = collezioneQuesiti.getQuesito(0);
        verificaQuesito(quesito, "xxx", "Questo e' il testo della domanda ?", 4,
                        "aaa", "bbb", "ccc", "b", "yyy", "d1");
        assertTrue("risposta d", quesito.getRisposta(3).equals("ddd"));
        assertTrue("risposta e", quesito.getRisposta(4) == null);
    }

    public void testSalvaCollezioneQuesiti2(){
        CollezioneQuesiti collezioneQuesiti = null;
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(nomeFile25);
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        try {
            daoxml.salvaCollezioneQuesiti(collezioneQuesiti, percorso+"it\\unibas\\pdd\\test\\provaSalvataggioCQ25.xml");
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        try {
            collezioneQuesiti = daoxml.caricaCollezioneQuesiti(percorso+"it\\unibas\\pdd\\test\\provaSalvataggioCQ25.xml");
        } catch (DAOException daoe) {
            System.err.println(daoe);
            fail();
        }
        verificaCollezione(collezioneQuesiti, "geo", "Geografia", 3, 3, 25);
        Argomento argomento = collezioneQuesiti.getArgomento("naz");
        verificaArgomento(argomento, "naz", "Nazioni Europee", 8);
        Difficolta difficolta = collezioneQuesiti.getDifficolta("d1");
        verificaDifficolta(difficolta, "d1", "Domanda di difficolta' media", 14);
        difficolta = collezioneQuesiti.getDifficolta("d2");
        verificaDifficolta(difficolta, "d2", "Domanda di difficolta' avanzata", 5);
        Quesito quesito = collezioneQuesiti.getQuesito(2);
        verificaQuesito(quesito, "cap03", "Qual e' la capitale del Regno Unito ?", 3,
                        "Il Cairo", "Roma", "Londra - esatta", "c", "cap", "d2");
    }

    public void verificaCollezione(CollezioneQuesiti collezioneQuesiti, 
                                        String id, String disciplina,
                                        int numeroArgomenti, int numeroDifficolta, 
                                        int numeroQuesiti) {
        assertTrue("id", collezioneQuesiti.getId().equals(id));
        assertTrue("disciplina", collezioneQuesiti.getDisciplina().equals(disciplina));
        assertTrue("numero argomenti", collezioneQuesiti.getNumeroArgomenti() == numeroArgomenti);
        assertTrue("numero difficolta", collezioneQuesiti.getNumeroDifficolta() == numeroDifficolta);
        assertTrue("numero quesiti", collezioneQuesiti.getNumeroQuesiti() == numeroQuesiti);
    }
        
    public void verificaArgomento(Argomento argomento, String id, 
                                    String nome, int numeroQuesiti) {
        assertTrue("id", argomento.getId().equals(id));
        assertTrue("nome argomento", argomento.getNome().equals(nome));                                         
        assertTrue("numero quesiti", argomento.getNumeroQuesiti() == numeroQuesiti);
    }

    public void verificaDifficolta(Difficolta difficolta, String id,
                                    String descrizione, int numeroQuesiti) {
        assertTrue("id", difficolta.getId().equals(id));
        assertTrue("descrizione", difficolta.getDescrizione().equals(descrizione)); 
        assertTrue("numero quesiti", difficolta.getNumeroQuesiti() == numeroQuesiti);
    }
    
    public void verificaQuesito(Quesito quesito, String id, 
                                    String domanda, int numeroRisposte,
                                    String rispostaA, String rispostaB,
                                    String rispostaC, String soluzione,
                                    String idArgomento, String idDifficolta) {
        assertTrue("id quesito", quesito.getId().equals(id)); 
        assertTrue("domanda: ", quesito.getNodoDomanda(0).getValore().equals(domanda));
        assertTrue("numero risposte", quesito.getNumeroRisposte() == numeroRisposte);
        assertTrue("risposta a", quesito.getRisposta(0).equals(rispostaA));
        assertTrue("risposta b", quesito.getRisposta(1).equals(rispostaB));
        assertTrue("risposta c", quesito.getRisposta(2).equals(rispostaC));
        assertTrue("risposta esatta", quesito.getSoluzione().equals(soluzione));
        String idArgomentoQ = quesito.getIdArgomento();
        assertTrue("argomento quesito", idArgomentoQ.equals(idArgomento));        
        String idDifficoltaQ = quesito.getIdDifficolta();
        assertTrue("difficolta", idDifficoltaQ.equals(idDifficolta));        
    }
}


