/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import java.util.ArrayList;
import it.unibas.pdd.modello.*;
import it.unibas.pdd.persistenza.DAOConfigurazione;

public class TestGenerazione extends TestCase {
    
    public TestGenerazione(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestGenerazione.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    Configurazione configurazione;
    String nomeFile1 = Costanti.NOME_FILE_1;
    String nomeFile2 = Costanti.NOME_FILE_2;
    String nomeFile3 = Costanti.NOME_FILE_3;
    String nomeFile4 = Costanti.NOME_FILE_4;
    String nomeFile5 = Costanti.NOME_FILE_5;
    
    protected void setUp() {
    }

    public void testGeneraCollezione1() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile1);
        } catch (Exception e) {
            System.err.println(e);
        }
        CollezioneQuesiti collezioneQuesiti = configurazione.generaCollezioneQuesiti("test1");
        boolean diversi = collezioneQuesiti.verificaDiversi();
        assertTrue("quesiti diversi", diversi);
        assertTrue("numero argomenti", collezioneQuesiti.getNumeroArgomenti() <= 3);
        assertTrue("numero difficolta", collezioneQuesiti.getNumeroDifficolta() <= 3);
        assertTrue("numero quesiti", collezioneQuesiti.getNumeroQuesiti() == 7);
        verificaQuesitiDifficolta(collezioneQuesiti, "d0");
        verificaQuesitiArgomento(collezioneQuesiti, "naz");
    }

    public void testGeneraCollezione2() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile2);
        } catch (Exception e) {
            System.err.println(e);
        }
        CollezioneQuesiti collezioneQuesiti = configurazione.generaCollezioneQuesiti("test2");
        boolean diversi = collezioneQuesiti.verificaDiversi();
        assertTrue("quesiti diversi", diversi);
        assertTrue("numero argomenti", collezioneQuesiti.getNumeroArgomenti() == 2);
        assertTrue("numero difficolta", collezioneQuesiti.getNumeroDifficolta() <= 3);
        assertTrue("numero quesiti", collezioneQuesiti.getNumeroQuesiti() == 10);
        //int numeroQuesitiReg = collezioneQuesiti.getArgomento("reg").getNumeroQuesiti();
        //assertTrue("numero quesiti reg", numeroQuesitiReg == 0);
        int numeroQuesitid0 = collezioneQuesiti.getDifficolta("d0").getNumeroQuesiti();
        assertTrue("numero quesiti d0", numeroQuesitid0 == 1);
        int numeroQuesitid2 = collezioneQuesiti.getDifficolta("d2").getNumeroQuesiti();
        assertTrue("numero quesiti d2", numeroQuesitid2 == 3);
        verificaQuesitiDifficolta(collezioneQuesiti, "d1");
        verificaQuesitiArgomento(collezioneQuesiti, "cap");
    }
    
    public void testGeneraCollezione3() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile3);
        } catch (Exception e) {
            System.err.println(e);
        }
        CollezioneQuesiti collezioneQuesiti = configurazione.generaCollezioneQuesiti("test3");
        boolean diversi = collezioneQuesiti.verificaDiversi();
        assertTrue("quesiti diversi", diversi);
        assertTrue("numero argomenti", collezioneQuesiti.getNumeroArgomenti() <= 3);
        assertTrue("numero difficolta", collezioneQuesiti.getNumeroDifficolta() == 3);
        assertTrue("numero quesiti", collezioneQuesiti.getNumeroQuesiti() == 8);
        int numeroQuesitid0 = collezioneQuesiti.getDifficolta("d0").getNumeroQuesiti();
        assertTrue("numero quesiti d0", numeroQuesitid0 == 1);
        int numeroQuesitid1 = collezioneQuesiti.getDifficolta("d1").getNumeroQuesiti();
        assertTrue("numero quesiti d1", numeroQuesitid1 == 4);
        int numeroQuesitid2 = collezioneQuesiti.getDifficolta("d2").getNumeroQuesiti();
        assertTrue("numero quesiti d2", numeroQuesitid2 == 3);
        verificaQuesitiDifficolta(collezioneQuesiti, "d2");
        verificaQuesitiArgomento(collezioneQuesiti, "reg");
    }

    private void verificaQuesitiDifficolta(CollezioneQuesiti collezioneQuesiti, String idDifficolta) {
        int numeroQuesitiD = 0;
        for (int i = 0; i < collezioneQuesiti.getNumeroQuesiti(); i++) {
            Quesito quesito = collezioneQuesiti.getQuesito(i);
            if (quesito.getIdDifficolta().equals(idDifficolta)) {
                numeroQuesitiD++;
            }
        }
        Difficolta difficolta = collezioneQuesiti.getDifficolta(idDifficolta);
        if (difficolta != null) {
            assertTrue ("numeroQuesiti "+idDifficolta, numeroQuesitiD == difficolta.getNumeroQuesiti());        
        }
    }
    
    private void verificaQuesitiArgomento(CollezioneQuesiti collezioneQuesiti, String idArgomento) {
        int numeroQuesitiArgomento = 0;
        for (int i = 0; i < collezioneQuesiti.getNumeroQuesiti(); i++) {
            Quesito quesito = collezioneQuesiti.getQuesito(i);
            if (quesito.getIdArgomento().equals(idArgomento)) {
                numeroQuesitiArgomento++;
            }
        }
        Argomento argomento = collezioneQuesiti.getArgomento(idArgomento);
        if (argomento != null) {
            assertTrue ("numeroQuesiti "+idArgomento, numeroQuesitiArgomento == argomento.getNumeroQuesiti());        
        }
    }
    
}
