/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import it.unibas.pdd.modello.*;
import it.unibas.pdd.persistenza.*;

public class TestGruppoQuestionari extends TestCase {
    
    public TestGruppoQuestionari(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestGruppoQuestionari.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    Configurazione configurazione;
    String nomeFile1 = Costanti.NOME_FILE_1;
    String nomeFile2 = Costanti.NOME_FILE_2;
    String nomeFile3 = Costanti.NOME_FILE_3;
    String nomeFile4 = Costanti.NOME_FILE_4;
    String nomeFile5 = Costanti.NOME_FILE_5;
        
    protected void setUp() {
    }
    
    public void testCostruttoreGruppo1() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile1);
        } catch (Exception e) {
            System.err.println(e);
        }
        GruppoQuestionari gruppoQuestionari = new GruppoQuestionari(configurazione, "Tprova");
        assertTrue("numero questionari", gruppoQuestionari.getNumeroQuestionari() == 4);
        verificaNumeroQuesiti(gruppoQuestionari, 3, 7);
        verificaRisposte(gruppoQuestionari);
    }
    
    public void testCostruttoreGruppo2() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile2);
        } catch (Exception e) {
            System.err.println(e);
        }
        GruppoQuestionari gruppoQuestionari = new GruppoQuestionari(configurazione, "Tprova");
        assertTrue("numero questionari", gruppoQuestionari.getNumeroQuestionari() == 5);
        verificaNumeroQuesiti(gruppoQuestionari, 4, 10);
        verificaRisposte(gruppoQuestionari);
    }
    
    public void testCostruttoreGruppo3() {
        try {
            configurazione = DAOConfigurazione.getInstance().carica(nomeFile3);
        } catch (Exception e) {
            System.err.println(e);
        }
        GruppoQuestionari gruppoQuestionari = new GruppoQuestionari(configurazione, "Tprova");
        assertTrue("numero questionari", gruppoQuestionari.getNumeroQuestionari() == 3);
        verificaNumeroQuesiti(gruppoQuestionari, 2, 8);
        verificaRisposte(gruppoQuestionari);
    }

    private void verificaNumeroQuesiti(GruppoQuestionari gruppoQuestionari,
                                       int numeroPermutazioni,
                                       int numeroQuesiti) {
        CollezioneQuesiti questionario = gruppoQuestionari.getQuestionario(0);
        assertTrue("numero domande 0", questionario.getNumeroQuesiti() == numeroQuesiti);
        for (int i = 1; i < numeroPermutazioni; i++) {
            questionario = gruppoQuestionari.getQuestionario(i);
            assertTrue("numero domande"+i, questionario.getNumeroQuesiti() == numeroQuesiti);
        }
        questionario = gruppoQuestionari.getQuestionario(numeroPermutazioni + 1);
        assertTrue("questionario nullo", questionario == null);
    }

    private void verificaRisposte(GruppoQuestionari gruppoQuestionari) {
        for (int i = 0; i < gruppoQuestionari.getNumeroQuestionari(); i++) {
            CollezioneQuesiti questionario = gruppoQuestionari.getQuestionario(i);
            verificaRisposteQuestionario(questionario);
        }
    }
    
    private void verificaRisposteQuestionario(CollezioneQuesiti questionario) {
        for (int i = 0; i < questionario.getNumeroQuesiti(); i++) {
            Quesito quesito = questionario.getQuesito(i);
            String soluzione = quesito.getSoluzione();
            int posizioneSoluzione = (int)soluzione.charAt(0) - 97;
            assertTrue("risposta" + i, quesito.getRisposta(posizioneSoluzione).indexOf("- esatta") != -1);
        }
    }
}
