/*
    PdD (Punto di Domanda) - a multiple-choice test management system
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ----
    PdD (Punto di Domanda) - un sistema per la gestione di questionari 
                             con domande a risposta multipla
    Copyright (C) 2003  Giansalvatore Mecca - mecca@unibas.it

    Questo  programma   software  libero;   lecito redistribuirlo  o
    modificarlo secondo i termini  della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free  Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma   distribuito nella  speranza che sia  utile, ma
    SENZA  ALCUNA GARANZIA;  senza  neppure la  garanzia implicita  di
    NEGOZIABILIT  o di  APPLICABILIT PER  UN PARTICOLARE  SCOPO.  Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo  programma deve  essere  distribuito assieme  ad una  copia
    della Licenza Pubblica Generica GNU;  in caso contrario, se ne pu
    ottenere  una scrivendo  alla Free  Software Foundation,  Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

package it.unibas.pdd.test;

import junit.framework.*;
import it.unibas.pdd.modello.*;

public class TestQuesito extends TestCase {
    
    public TestQuesito(java.lang.String testName) {
        super(testName);
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TestQuesito.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
     private Quesito creaQuesito(String codiceQuesito, 
                            String codiceArgomento, 
                            String codiceDifficolta,
                            String soluzione) {
        Quesito quesito = new Quesito();
        quesito.setId(codiceQuesito);
        quesito.setIdDifficolta(codiceDifficolta);
        quesito.setIdArgomento(codiceArgomento);
        NodoDomanda nodoDomanda = new NodoDomanda();
        nodoDomanda.setTipo("testo");
        nodoDomanda.setValore("Domanda da fare ?");
        quesito.addNodoDomanda(nodoDomanda);
        quesito.setSoluzione(soluzione);
        quesito.addRisposta("risposta a");
        quesito.addRisposta("risposta b");
        quesito.addRisposta("risposta c");    
        return quesito;
    }
     
    public void testCopia1() {
        Quesito quesito = creaQuesito("q0", "arg", "d0", "b");
        Quesito copia = quesito.copia();
        assertTrue("oid", copia != quesito);
        assertTrue("id1", copia.getId().equals(quesito.getId()));
        assertTrue("id2", copia.getId() != quesito.getId());
        assertTrue("arg1", copia.getIdArgomento().equals(quesito.getIdArgomento()));
        assertTrue("arg2", copia.getIdArgomento() != quesito.getIdArgomento());
        assertTrue("diff1", copia.getIdDifficolta().equals(quesito.getIdDifficolta()));
        assertTrue("diff2", copia.getIdDifficolta() != quesito.getIdDifficolta());
        assertTrue("sol1", copia.getSoluzione().equals(quesito.getSoluzione()));
        assertTrue("sol2", copia.getSoluzione() != quesito.getSoluzione());
        NodoDomanda nodoQuesito = quesito.getNodoDomanda(0);
        NodoDomanda nodoCopia = copia.getNodoDomanda(0);
        assertTrue("nodo1", nodoCopia.getTipo().equals(nodoQuesito.getTipo()));
        assertTrue("nodo2", nodoCopia.getTipo() != nodoQuesito.getTipo());
        assertTrue("nodo3", nodoCopia.getValore().equals(nodoQuesito.getValore()));
        assertTrue("nodo4", nodoCopia.getValore() != nodoQuesito.getValore());
        for (int i = 0; i < quesito.getNumeroRisposte(); i++) {
            String rispostaQuesito = quesito.getRisposta(i);
            String rispostaCopia = copia.getRisposta(i);
            assertTrue("risp1" + i, rispostaCopia.equals(rispostaQuesito));
            assertTrue("nodo2" + i, rispostaCopia != rispostaQuesito);
        }
    }
    
}
