<?xml version="1.0" ?>

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="collezioneQuesiti">
        <html>
        <head>
            <title>Test <xsl:value-of select="@id"/></title>
            <style type="text/css">
               body {
                    font-size: 0.9em;
               }
               span.titolo {
                    font-weight: bold;
                    font-size: 1.2em;
                    font-family: Arial;
               }
               span.mini {
                    font-size: 0.8em;
               }
               h3 {
                    font-family: Arial;
                    font-size: 1em;
               }
               ol.risposte {
                    margin-top: 0.2em;
               }
               li.risposta {
                    list-style-type: lower-alpha;
               }
               li.quesito {
                    margin-top: 1em;
                    page-break-inside: avoid;
               }
               pre {
                    margin-top: 0em;
                    margin-bottom: 0.3em;
                    padding-top: 0em;
                    padding-left: 1em;
                    font-weight: normal;
               }    
               code {
                    font-weight: normal;
               }
            </style>
        </head>
        <body>
        <div>
        <span class="titolo">Test di Valutazione</span> - 
        <span class="mini"><xsl:value-of select="@id" /></span>
        </div>
        <h3>Cognome e Nome: __________________________ Matricola: ____________ </h3>
        <ol>
            <xsl:apply-templates />
        </ol>
        </body>
        </html>
    </xsl:template>

    <xsl:template match="quesito">
        <li class="quesito">
            <xsl:apply-templates />
            <span>Difficolta: <strong><xsl:value-of select="@difficolta" /></strong></span>
        </li>
    </xsl:template>
    
    <xsl:template match="domanda" />

    <xsl:template match="listaRisposte">
        <span>Soluzione: <strong><xsl:value-of select="@soluzione" /></strong></span>    
    </xsl:template>

    <xsl:template match="soluzione">
        Soluzione: <strong><xsl:value-of select="@idref" /></strong>
    </xsl:template>

</xsl:stylesheet>